<?php
/**
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$fieldsets = $this->form->getFieldsets();

if (isset($fieldsets['core'])) {
    unset($fieldsets['core']);
}

if (isset($fieldsets['params'])) {
    unset($fieldsets['params']);
}

$tmp = $this->data->jcfields ?? [];
$customFields = [];

foreach ($tmp as $customField) {
    $customFields[$customField->name] = $customField;
}

unset($tmp);

?>
<?php foreach ($fieldsets as $group => $fieldset) : ?>
    <?php $fields = $this->form->getFieldset($group); ?>
    <?php if (count($fields)) : ?>
        <fieldset id="users-profile-custom-<?php echo $group; ?>" class="com-users-profile__custom users-profile-custom-<?php echo $group; ?>">
            <?php if (isset($fieldset->label) && ($legend = trim(Text::_($fieldset->label))) !== '') : ?>
			<legend class="text-body-secondary border-bottom mt-5 pb-3 mb-4"><svg xmlns="http://www.w3.org/2000/svg" style="margin:-4px 10px 0 0;--fa-rotate-angle: -45deg;" width="21" height="21" fill="currentColor" class="major_color-lighten-30 fa-flip-horizontal fa-rotate-by" viewBox="0 0 16 16"><path d="M0 8a4 4 0 0 1 7.465-2H14a.5.5 0 0 1 .354.146l1.5 1.5a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0L13 9.207l-.646.647a.5.5 0 0 1-.708 0L11 9.207l-.646.647a.5.5 0 0 1-.708 0L9 9.207l-.646.647A.5.5 0 0 1 8 10h-.535A4 4 0 0 1 0 8m4-3a3 3 0 1 0 2.712 4.285A.5.5 0 0 1 7.163 9h.63l.853-.854a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.793-.793-1-1h-6.63a.5.5 0 0 1-.451-.285A3 3 0 0 0 4 5"/><path d="M4 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/></svg><?php echo $legend; ?></legend>
            <?php endif; ?>
            <?php if (isset($fieldset->description) && trim($fieldset->description)) : ?>
                <p><?php echo $this->escape(Text::_($fieldset->description)); ?></p>
            <?php endif; ?>
            <dl class="dl-horizontal">
                <?php foreach ($fields as $field) : ?>
                    <?php // Correct the field name so that subform custom fields show up. ?>
                    <?php if ($field->type === 'Subform' && $field->fieldname === 'row') : ?>
                        <?php preg_match("/jform\[com_fields]\[(.*)]/", $field->name, $matches); ?>
                        <?php $field->fieldname = $matches[1]; ?>
                    <?php endif; ?>
                    <?php if (!$field->hidden && $field->type !== 'Spacer') : ?>
                        <dt>
                            <?php echo $field->title; ?>
                        </dt>
                        <dd>
                            <?php if (array_key_exists($field->fieldname, $customFields)) : ?>
                                <?php echo strlen($customFields[$field->fieldname]->value) ? $customFields[$field->fieldname]->value : Text::_('COM_USERS_PROFILE_VALUE_NOT_FOUND'); ?>
                            <?php elseif (HTMLHelper::isRegistered('users.' . $field->id)) : ?>
                                <?php echo HTMLHelper::_('users.' . $field->id, $field->value); ?>
                            <?php elseif (HTMLHelper::isRegistered('users.' . $field->fieldname)) : ?>
                                <?php echo HTMLHelper::_('users.' . $field->fieldname, $field->value); ?>
                            <?php elseif (HTMLHelper::isRegistered('users.' . $field->type)) : ?>
                                <?php echo HTMLHelper::_('users.' . $field->type, $field->value); ?>
                            <?php else : ?>
                                <?php echo HTMLHelper::_('users.value', $field->value); ?>
                            <?php endif; ?>
                        </dd>
                    <?php endif; ?>
                <?php endforeach; ?>
            </dl>
        </fieldset>
    <?php endif; ?>
<?php endforeach; ?>
