<?php
/**
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

?>
<?php $fields = $this->form->getFieldset('params'); ?>
<?php if (count($fields)) : ?>
    <fieldset id="users-profile-custom" class="com-users-profile__params">
        <legend class="text-body-secondary border-bottom mt-5 pb-3 mb-4"><svg xmlns="http://www.w3.org/2000/svg" style="margin:-4px 8px 0 0;" width="20" height="20" fill="currentColor" class="major_color-lighten-30" viewBox="0 0 16 16"><path d="M7.068.727c.243-.97 1.62-.97 1.864 0l.071.286a.96.96 0 0 0 1.622.434l.205-.211c.695-.719 1.888-.03 1.613.931l-.08.284a.96.96 0 0 0 1.187 1.187l.283-.081c.96-.275 1.65.918.931 1.613l-.211.205a.96.96 0 0 0 .434 1.622l.286.071c.97.243.97 1.62 0 1.864l-.286.071a.96.96 0 0 0-.434 1.622l.211.205c.719.695.03 1.888-.931 1.613l-.284-.08a.96.96 0 0 0-1.187 1.187l.081.283c.275.96-.918 1.65-1.613.931l-.205-.211a.96.96 0 0 0-1.622.434l-.071.286c-.243.97-1.62.97-1.864 0l-.071-.286a.96.96 0 0 0-1.622-.434l-.205.211c-.695.719-1.888.03-1.613-.931l.08-.284a.96.96 0 0 0-1.186-1.187l-.284.081c-.96.275-1.65-.918-.931-1.613l.211-.205a.96.96 0 0 0-.434-1.622l-.286-.071c-.97-.243-.97-1.62 0-1.864l.286-.071a.96.96 0 0 0 .434-1.622l-.211-.205c-.719-.695-.03-1.888.931-1.613l.284.08a.96.96 0 0 0 1.187-1.186l-.081-.284c-.275-.96.918-1.65 1.613-.931l.205.211a.96.96 0 0 0 1.622-.434zM12.973 8.5H8.25l-2.834 3.779A4.998 4.998 0 0 0 12.973 8.5m0-1a4.998 4.998 0 0 0-7.557-3.779l2.834 3.78zM5.048 3.967l-.087.065zm-.431.355A4.98 4.98 0 0 0 3.002 8c0 1.455.622 2.765 1.615 3.678L7.375 8zm.344 7.646.087.065z"/></svg><?php echo Text::_('COM_USERS_SETTINGS_FIELDSET_LABEL'); ?></legend>
        <dl class="dl-horizontal">
            <?php foreach ($fields as $field) : ?>
                <?php if (!$field->hidden) : ?>
                    <dt>
                        <?php echo $field->title; ?>
                    </dt>
                    <dd>
                        <?php if (HTMLHelper::isRegistered('users.' . $field->id)) : ?>
                            <?php echo HTMLHelper::_('users.' . $field->id, $field->value); ?>
                        <?php elseif (HTMLHelper::isRegistered('users.' . $field->fieldname)) : ?>
                            <?php echo HTMLHelper::_('users.' . $field->fieldname, $field->value); ?>
                        <?php elseif (HTMLHelper::isRegistered('users.' . $field->type)) : ?>
                            <?php echo HTMLHelper::_('users.' . $field->type, $field->value); ?>
                        <?php else : ?>
                            <?php echo HTMLHelper::_('users.value', $field->value); ?>
                        <?php endif; ?>
                    </dd>
                <?php endif; ?>
            <?php endforeach; ?>
        </dl>
    </fieldset>
<?php endif; ?>
