<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

class SppagebuilderAddonProgress_bar extends SppagebuilderAddons
{
	
	public function render()
	{
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$class .= (isset($settings->shape) && $settings->shape) ? 'sppb-progress-' . $settings->shape : '';
		$type = (isset($settings->type) && $settings->type) ? $settings->type : '';
		$progress = (isset($settings->progress) && $settings->progress) ? $settings->progress : '';
		$text = (isset($settings->text) && $settings->text) ? $settings->text : '';
		// Fixed animation for new Bootstrap
		// OLD: $stripped = (isset($this->addon->settings->stripped) && $this->addon->settings->stripped) ? $this->addon->settings->stripped : '';
		$stripped = (isset($settings->stripped) && $settings->stripped) ? ' progress-bar-striped' : '';
		// Fixed animation for new Bootstrap
		// OLD: $active = (isset($this->addon->settings->active) && $this->addon->settings->active) ? $this->addon->settings->active : '';
		$active = (isset($this->addon->settings->active) && $this->addon->settings->active) ? ' progress-bar-animated' : '';
		$show_percentage = (isset($settings->show_percentage) && $settings->show_percentage) ? $settings->show_percentage : 0;

		//Output
		$output = '';
		
		if($type == 'flex') {
			$output .= '<div class="flex-text-wrapper"><div class="flex-text">'.  $text .'</div>';
			$output .= '<div class="flex-progress-text">'. (int) $progress .'%</div>';
			$output .= '</div>';
		} 
		
		$output .= '<div class="progress sppb-progress ' . $class . '" role="progressbar">';
		$output .= '<div style="min-width:0;" class="progress-bar sppb-progress-bar ' . $type . $stripped . $active . '" role="progressbar" aria-valuenow="' . (int) $progress . '" aria-valuemin="0" aria-valuemax="100" data-width="' . (int) $progress . '%">';

		if ($type != 'flex')
		{
			$output .= '<div class="progress-label d-block my-5 align-middle">';
			$output .= ($text) ? $text : '';
			$output .= '</div>';
		}
		
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function css()
	{
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$cssHelper = new CSSHelper($addon_id);
		$css = '';

		$type = (isset($settings->type) && $settings->type) ? $settings->type : '';
		$text_color = (isset($settings->text_color) && $settings->text_color) ? $settings->text_color : '';
		
		$animation_duration = (isset($settings->animation_duration) && $settings->animation_duration) ? $settings->animation_duration : 0;
		$animation_delay = (isset($settings->animation_delay) && $settings->animation_delay) ? $settings->animation_delay : 0;

		$barStyle = $cssHelper->generateStyle('.sppb-progress', $settings, ['custom_height' => 'height']);
		$barLineHeightStyle = $cssHelper->generateStyle('.sppb-progress-bar', $settings, ['custom_height' => 'line-height']);
		$textStyle = $cssHelper->generateStyle('.progress-label', $settings, ['text_color' => 'color'], false);

		$flexStyle = '';
		if($type == 'flex') {
			$flexStyle = $cssHelper->generateStyle('.flex-text-wrapper', $settings, ['text_color' => 'color'], false);
		}
		
		if($animation_duration || $animation_delay) {
			$css .= $addon_id . ' .sppb-progress-bar{'
				. '-webkit-transition:' . $animation_duration . 's ease '.$animation_delay.'s;'
				. 'transition:' . $animation_duration . 's ease '.$animation_delay.'s;'
				. '}';
		}
		
		$textFontStyle = $cssHelper->typography('.progress-label, .flex-text-wrapper', $settings, 'label_typography', ['font' => 'text_fontfamily', 'size' => 'text_fontsize', 'line_height' => 'text_lineheight', 'weight' => 'text_fontweight']);

		$customBarStyle = $cssHelper->generateStyle('.sppb-progress', $settings, ['bar_background' => 'background-color'], false);
		$customBarBackgroundStyle = $cssHelper->generateStyle('.sppb-progress-bar', $settings, ['custom_color' => 'background-color'], false);

		$css .= $customBarStyle;
		$css .= $customBarBackgroundStyle;
		$css .= $barStyle;
		$css .= $barLineHeightStyle;
		$css .= $textStyle;
		$css .= $textFontStyle;
		$css .= $flexStyle;

		return $css;
	}
}
